// ウィンドウサイズの指定
final int WIN_WIDTH = 800, WIN_HEIGHT = 600;

class RobotStatus {
  boolean DO_RA1, DO_RA2;
  boolean DO_LA1, DO_LA2;
  boolean DO_RB1, DO_RB2;
  boolean DO_LB1, DO_LB2;
  boolean DO_JT1, DO_JT2;
  float   JT_Angle = 0.0;    // [deg]
  
  CommanderMonitor cm = new CommanderMonitor();
  RobotDisplay     rd = new RobotDisplay();
  TextInformation  ti = new TextInformation();

  // コンストラクター
  RobotStatus() {
  }
  // ロボットに送信されるフラグに基づいて各DOの状態を推測
  void refresh() {
    // Arduinoとの通信コマンドに基づいて変数の内容を更新する：通信プロトコル２以降
    DO_RA1 = DO_RA2 = DO_LA1 = DO_LA2 = DO_RB1 = DO_RB2 = DO_LB1 = DO_LB2 = DO_JT1 = DO_JT2 = false;
    if ((command_flag & 0b00000011) == 0b00000011); else {
      if ((command_flag & 0b00000001) != 0) DO_JT1 = true;  // CCW
      if ((command_flag & 0b00000010) != 0) DO_JT2 = true;  // CW
    }
    if ((command_flag & 0b11000000) == 0b11000000); else {
      if ((command_flag & 0b10000000) != 0) DO_RA1 = DO_LA1 = true;  // FWD
      if ((command_flag & 0b01000000) != 0) DO_RA2 = DO_LA2 = true;  // BWD
    }
    if ((command_flag & 0b00110000) == 0b00110000); else {
      if ((command_flag & 0b00100000) != 0) DO_RB1 = DO_LB1 = true;  // FWD
      if ((command_flag & 0b00010000) != 0) DO_RB2 = DO_LB2 = true;  // BWD
    }
  }
  void draw_GUI() {
    refresh();

    // 文字情報の表示
    ti.DO_monitor();
    ti.system_monitor();
    ti.robot_monitor();

    // 画像情報の表示
    rd.display_robot();
    cm.display_commander();
    
    // ショートメッセージの表示
    fill(200, 200, 200);
    stroke(0, 0, 0);
    rect(0, height - 40, width - 1, height -1);
    SM.display_short_message(10, height - 12);
  }
}

RobotStatus rs = new RobotStatus();

// ゲームパッドやキーボード入力の状態表示用クラス
class CommanderMonitor {
  // コンストラクター
  CommanderMonitor() {
  }
  // 該当するマス目の文字列を返す
  String commander_name(int no) {
    switch (no) {
      case  0 : return "LB (7)";
      case  1 : return "↑ (8)";
      case  2 : return "RB (9)";
      case  3 : return "A (-)";
      case  4 : return "← (4)";
      case  6 : return "→ (6)";
      case  7 : return "X (+)";
      case  8 : return "LT (1)";
      case  9 : return "↓ (2)";
      case 10 : return "RT (3)";
      case 12 : return "Y (0)";
      case 13 : return "B (SPC)";
      case 14 : return "Home";
    }
    return "";
  }
  // 該当するマス目の状態を返す
  boolean check_commander(int no) {
    switch (no) {
      case  0 : return mc.button_LB;                  // 一定角度回転(CCW)
      case  1 : return (mc.hat == 2) ? true : false;  // 前進
      case  2 : return mc.button_RB;                  // 一定角度回転(CW)
      case  3 : return mc.button_A;
      case  4 : return (mc.hat == 8) ? true : false;  // 並進（左）
      case  6 : return (mc.hat == 4) ? true : false;  // 並進（右）
      case  7 : return mc.button_X;                   // Advanced <-> Easy
      case  8 : return mc.button_LT;                  // 連続回転(CCW)
      case  9 : return (mc.hat == 6) ? true : false;  // 後進
      case 10 : return mc.button_RT;                  // 連続回転(CW)
      case 12 : return mc.button_Y;                   // 直進姿勢
      case 13 : return mc.button_B;                   // 全モーター停止
      case 14 : return ks.home;                       // 関節角度初期化
    }
    return false;
  }
  // ゲームパッドとキーボード入力の状態表示
  void display_commander() {
    int x0, y0;    // 左上の座標
    int dx, dy;    // マス目のサイズ
    
    dx = 100;  dy = 40;
    x0 = width - dx * 4 - 20; y0 = 360;
    stroke(0, 0, 0);
    textAlign(CENTER, CENTER);
    int no = 0;
    for (int l = 0; l < 4; l++) {
      for (int c = 0; c < 4; c++) {
        if (check_commander(no)) fill(240, 240,  64);
          else                   fill(255, 255, 255);
        rect(x0 + c * dx, y0 + l * dy, dx, dy);
        fill(0, 0, 0);
        text(commander_name(no), x0 + c * dx + dx / 2, y0 + l * dy + dy / 2);
        no++;
      }
    }
    textAlign(LEFT, BASELINE);
  }
}

class RobotDisplay {
  // コンストラクター
  RobotDisplay() {
  }
  // ロボットの状態をグラフィカルに表示
  void display_robot() {
    int xj, yj;  // 関節部の座標値を基準とする
    int w,  h;   // リンクの幅，リンクの長さを基準とする
    int [] x = {0, 0, 0, 0};  // 四角形のx座標 左上，右上，左下，右下の順
    int [] y = {0, 0, 0, 0};  // 四角形のy座標 左上，右上，左下，右下の順
    
    xj = 120; yj = 250;
    w  =  40; h  = 200;
    
    // xjの補正（関節角度に応じて画像を左右に動かす）
    xj += 0.5 * h * sin(radians(rs.JT_Angle/2));  // 0.5はゲイン．目分量で調整
    
    stroke(255, 0, 0);    // 外形線
    fill(255, 255, 255);  // 塗りつぶし
    // 前方リンク
    x[0] = x[2] = - w/2;
    x[1] = x[3] =   w/2;
    y[0] = y[1] = - h;
    y[2] = y[3] =   0;
    rotate4p(x, y, radians(rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    // 後方リンク
    x[0] = x[2] = - w/2;
    x[1] = x[3] =   w/2;
    y[0] = y[1] =   0;
    y[2] = y[3] =   h;
    rotate4p(x, y, radians(-rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    // 関節部
    set_fill_motor(rs.DO_JT1, rs.DO_JT2);
    ellipse(xj, yj, w, w);
    // 駆動部
    // (1) 左前方
    set_fill_motor(rs.DO_LA1, rs.DO_LA2);
    x[0] = x[1] = - w;
    y[0] = y[2] = -h/8 * 7;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    x[0] = x[1] = - w;
    y[0] = y[2] = -h/8 * 4;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    // (2) 右前方
    set_fill_motor(rs.DO_RA1, rs.DO_RA2);
    x[0] = x[1] = w;
    y[0] = y[2] = -h/8 * 7;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    x[0] = x[1] = w;
    y[0] = y[2] = -h/8 * 4;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    // (3) 左後方
    set_fill_motor(rs.DO_LB1, rs.DO_LB2);
    x[0] = x[1] = - w;
    y[0] = y[2] = h/8 * 7;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(-rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    x[0] = x[1] = - w;
    y[0] = y[2] = h/8 * 4;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(-rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    // (4) 右後方
    set_fill_motor(rs.DO_RB1, rs.DO_RB2);
    x[0] = x[1] = w;
    y[0] = y[2] = h/8 * 7;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(-rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
    x[0] = x[1] = w;
    y[0] = y[2] = h/8 * 4;
    x[2] = (x[0] -= (w / 2 * 0.6));
    x[3] = (x[1] += (w / 2 * 0.6));
    y[1] = (y[0] -= h * 0.5 / 4);
    y[3] = (y[2] += h * 0.5 / 4);
    rotate4p(x, y, radians(-rs.JT_Angle/2));
    slide4p(x, y, xj, yj);
    rect4p(x, y);
  }
  // 四点の座標を指定した四角形
  void rect4p(int [] x, int [] y) {
    beginShape();
    vertex(x[0], y[0]);
    vertex(x[1], y[1]);
    vertex(x[3], y[3]);
    vertex(x[2], y[2]);
    vertex(x[0], y[0]);
    endShape();
  }
  // グラフィクス座標系（ｙ座標が逆）に対応した４点の座標の回転行列
  void rotate4p(int [] x, int []y, float rad) {
    int x1, y1;
    for (int i = 0; i < 4; i++) {
      x1 = (int)(x[i] * cos(-rad) - y[i] * sin(-rad));
      y1 = (int)(x[i] * sin(-rad) + y[i] * cos(-rad));
      x[i] = x1;
      y[i] = y1;
    }
  }
  // ４点の座標の座標の並進
  void slide4p(int [] x0, int []y0, int x, int y) {
    for (int i = 0; i < 4; i++) {
      x0[i] += x;
      y0[i] += y;
    }
  }
  // モーターの状態に応じて塗り潰し色を変更
  void set_fill_motor(boolean DO1, boolean DO2) {
    if (DO1 && ! DO2)       fill(0, 0, 255);
      else if (!DO1 && DO2) fill(255, 0, 0);
      else                  fill(255, 255, 255);
  }
}

// 文字情報のGUI表示
class TextInformation {
  // コンストラクター
  TextInformation() {
  }
  // Arduino側のデジタル出力の状態をテキスト表示する
  void DO_monitor() {
    int tx, ty;
    int dx, dy;
    // テキスト情報の表示（DO）
    tx = width - 160; ty = 30;
    fill(0, 0, 0);
    textAlign(LEFT, BASELINE);
    textSize(20);
    dx = 100; dy = 24;
    text("[DO]",   tx, ty); ty += dy;
    display_text_info("DO_RA1", OnOff(rs.DO_RA1), tx, ty, dx); ty += dy;
    display_text_info("DO_RA2", OnOff(rs.DO_RA2), tx, ty, dx); ty += dy;
    display_text_info("DO_LA1", OnOff(rs.DO_LA1), tx, ty, dx); ty += dy;
    display_text_info("DO_LA2", OnOff(rs.DO_LA2), tx, ty, dx); ty += dy;
    display_text_info("DO_RB1", OnOff(rs.DO_RB1), tx, ty, dx); ty += dy;
    display_text_info("DO_RB2", OnOff(rs.DO_RB2), tx, ty, dx); ty += dy;
    display_text_info("DO_LB1", OnOff(rs.DO_LB1), tx, ty, dx); ty += dy;
    display_text_info("DO_LB2", OnOff(rs.DO_LB2), tx, ty, dx); ty += dy;
    display_text_info("DO_JT1", OnOff(rs.DO_JT1), tx, ty, dx); ty += dy;
    display_text_info("DO_JT2", OnOff(rs.DO_JT2), tx, ty, dx); ty += dy;
  }
  // システムの状態をテキスト表示する
  void system_monitor() {
    int tx, ty;
    int dx, dy;
    // テキスト情報の表示（DO）
    tx = width - 400; ty = 30;
    fill(0, 0, 0);
    textAlign(LEFT, BASELINE);
    textSize(20);
    dx = 110; dy = 24;
    text("[System]",   tx, ty); ty += dy;
    display_text_info("Mode",     (advance_mode       ? "Advanced" : "Easy"),             tx, ty, dx); ty += dy;
    display_text_info("Auto",     (mc.autoCommand < 1 ? "Disable"  : nf(mc.autoCommand)), tx, ty, dx); ty += dy;
    display_text_info("GamePad",  (debug_nogamepad    ? "Disable"  : "Enable"),           tx, ty, dx); ty += dy;
    display_text_info("Debug",    (debug              ? "On"       : "Off")   ,           tx, ty, dx); ty += dy;
    display_text_info("Serial",   (debug_noserial     ? "Disable"  : "Enable"),           tx, ty, dx); ty += dy;
    display_text_info("Wireless", (Wireless           ? "XBee"     : "USB"),              tx, ty, dx); ty += dy;
  }
  // ロボットの状態をテキスト表示する
  void robot_monitor() {
    int tx, ty;
    int dx, dy;
    // テキスト情報の表示（DO）
    tx = width - 400; ty = 250;
    fill(0, 0, 0);
    textAlign(LEFT, BASELINE);
    textSize(20);
    dx = 110; dy = 24;
    text("[Robot]",   tx, ty); ty += dy;
    display_text_info("JT_Angle", nf(rs.JT_Angle),       tx, ty, dx); ty += dy;
    display_text_info("serial", binary(command_flag, 8), tx, ty, dx); ty += dy;
  }
  // 見出し付きでテキスト表示
  void display_text_info(String name, String status, int x, int y, int dx) {
    text(name + ":", x, y);
    text(status    , x + dx, y);
  }
  // テキスト情報の表示
  // trueをON, falseをOFF
  String OnOff(boolean f) {
    return f ? "ON" : "OFF";
  }
}
